﻿using System;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Globalization;
using System.Linq;
using System.Text;

namespace WPF.PresentationLayer.Resources.Validators
{
    [AttributeUsage(AttributeTargets.All)]
    public sealed class ConditionalBooleanValidatorAttribute : BooleanValidatorAttribute
    {
        public string ConditionalProperty { get; private set; }
        public string SecondConditionalProperty { get; private set; }

        public ConditionalBooleanValidatorAttribute(string conditionalProperty, string secondConditionalProperty, string errorMessage)
            : base(errorMessage)
        {
            ConditionalProperty = conditionalProperty;
            SecondConditionalProperty = secondConditionalProperty;
        }

        public ConditionalBooleanValidatorAttribute(string conditionalProperty, string errorMessage)
            : base(errorMessage)
        {
            ConditionalProperty = conditionalProperty;
        }

        public ConditionalBooleanValidatorAttribute(string conditionalProperty, string secondConditionalProperty, string errorMessage, bool expectedValue)
            : base(errorMessage, expectedValue)
        {
            ConditionalProperty = conditionalProperty;
            SecondConditionalProperty = secondConditionalProperty;
        }

        public ConditionalBooleanValidatorAttribute(string conditionalProperty, string errorMessage, bool expectedValue)
            : base(errorMessage, expectedValue)
        {
            ConditionalProperty = conditionalProperty;
        }

        protected override ValidationResult IsValid(object value, ValidationContext validationContext)
        {
            if (validationContext == null) throw new ArgumentNullException("validationContext");

            if( !String.IsNullOrEmpty(ConditionalProperty) )
            {
                var property = validationContext.ObjectType.GetProperty( ConditionalProperty );
                if( property!=null )
                {
                    var propertyValue = property.GetValue(validationContext.ObjectInstance, null);
                    if (propertyValue != null && !Convert.ToBoolean(propertyValue, CultureInfo.InvariantCulture))
                    {
                        //SkipValidation
                        return null;
                    }
                }
             }


            if (!String.IsNullOrEmpty(SecondConditionalProperty))
            {
                var secondConditionalProperty = validationContext.ObjectType.GetProperty(SecondConditionalProperty);
                if (secondConditionalProperty != null)
                {
                    var secondConditionalPropertyValue = secondConditionalProperty.GetValue(validationContext.ObjectInstance, null);
                    if (secondConditionalPropertyValue != null && !Convert.ToBoolean(secondConditionalPropertyValue, CultureInfo.InvariantCulture))
                    {
                        //SkipValidation
                        return null;
                    }
                }
            }

            return base.IsValid(value, validationContext);
        }
    }
}
